% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_zero_inflated_nb_data_re.R
\name{simulate_zero_inflated_nb_random_effect_data}
\alias{simulate_zero_inflated_nb_random_effect_data}
\title{Simulated zero-inflated negative binomial data with random effects}
\usage{
simulate_zero_inflated_nb_random_effect_data(
  ncellsper,
  X,
  Z,
  alpha,
  beta,
  phi,
  sigma.a,
  sigma.b,
  id.levels = NULL,
  sim.seed = NULL
)
}
\arguments{
\item{ncellsper}{Vector giving the number of cells per individual.  Length of the vector is taken as the number of individuals.}

\item{X}{Covariate matrix (without intercept) for the (conditional) mean model.}

\item{Z}{Covariate matrix (without intercept) for the zero-inflation model.}

\item{alpha}{Column vector of true parameters from the zero-inflation model. Number of rows must match number of columns in Z.}

\item{beta}{Column vector of true parameters from the (conditional) mean model. Number of rows must match number of columns in X.}

\item{phi}{Overdispersion parameter for the negative binomial distribution (see details for more about parameterization).}

\item{sigma.a}{Standard deviation for the zero-inflation model random intercept.}

\item{sigma.b}{Standard deviation for the (conditional) mean random intercept.}

\item{id.levels}{Individual-level IDs. If NULL set as 1,2,... up to the number of individuals.}

\item{sim.seed}{Random seed to be used. If NULL one will be randomly chosen.}
}
\value{
Y Simulated counts

X Covariate matrix (without intercept) for the (conditional) mean model.

Z Covariate matrix (without intercept) for the zero-inflation model.

a Random effects for the zero-inflation model.

b Random effects for the (conditional) mean model.

alpha Column vector of true parameters from the zero-inflation model. Number of rows must match number of columns in Z.

beta Column vector of true parameters from the (conditional) mean model. Number of rows must match number of columns in X.

phi Overdispersion parameter for the negative binomial distribution (see details for more about parameterization).

sigma.a Standard deviation for the zero-inflation model random intercept.

sigma.b Standard deviation for the (conditional) mean random intercept.

nind Number of individuals.

ncellsper Vector giving the number of cells per individual.

id.levels Individual-level IDs.
}
\description{
Simulated zero-inflated negative binomial data with random effects
}
\examples{
# Set Parameters to Simulate Some Data

nind<-10;ncellsper<-rep(50,nind)
sigma.a<-.5;sigma.b<-.5;phi<-.1
alpha<-c(1,0,-.5,-2);beta<-c(2,0,-.1,.6)
beta2<-c(2,1,-.1,.6)
id.levels<-1:nind;nind<-length(id.levels)
id<-rep(id.levels,times=ncellsper)
sim.seed<-1234

# Simulate individual level covariates

t2d_sim<-rep(rbinom(nind,1,p=.4),times=ncellsper)
cdr_sim<-rbeta(sum(ncellsper),3,6)
age_sim<-rep(sample(c(20:60),size=nind,replace = TRUE),times=ncellsper)

# Construct design matrices

Z<-cbind(scale(t2d_sim),scale(age_sim),scale(cdr_sim))
colnames(Z)<-c("t2d_sim","age_sim","cdr_sim")
X<-cbind(scale(t2d_sim),scale(age_sim),scale(cdr_sim))
colnames(X)<-c("t2d_sim","age_sim","cdr_sim")

# Simulate Data

sim_dat<-matrix(nrow=2,ncol=sum(ncellsper))
for(i in 1:nrow(sim_dat)){
   sim_dat[i,]<-simulate_zero_inflated_nb_random_effect_data(ncellsper,X,Z,alpha,beta2
   ,phi,sigma.a,sigma.b,id.levels=NULL)$Y
}
rownames(sim_dat)<-paste("Gene",1:2)
}
