% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_tpexp.R
\name{qm_tpexp}
\alias{qm_tpexp}
\title{Quartile method estimation of the two-parameter exponential distribution}
\source{
Elgmati, E., Gregni, N. (2016). Quartile Method Estimation of Two-Parameter Exponential Distribution Data with Outliers.
\emph{International Journal of Statistics and Probability}, \emph{5(5)}, 12-15.
\doi{http://dx.doi.org/10.5539/ijsp.v5n5p12}
}
\usage{
qm_tpexp(x, methods = c("Q13"))
}
\arguments{
\item{x}{vector of quantile (or a data set).}

\item{methods}{there are two quartile methods as follows;
"Q13" stand for the first and the third quartile method (default), and
"Q12" stand for the first and the second quartile (median) method.}
}
\value{
the estimate three values for the two-parameter exponential dist. as follows:
\code{qmtheta.hat}  gives the estimate location parameter,
\code{qmbeta.hat}   gives the estimate scale parameter,
and \code{qmlamda.hat} gives the estimate the rate.
}
\description{
To estimate the location (or shift) and scale parameters for the two-parameter exponential distribution
based on quartile method. See detail in \code{source}
}
\examples{
x1 <- c(25,43,53,65,76,86,95,115,132,150) # test a data set
qm_tpexp(x1,"Q13")  # or qm_tpexp(x1)
qm_tpexp(x1,"Q12")

}
