#' Progressively misaligned cluster data matrices
#'
#' Simulated data of progressively misaligned clusters
#' on which to fit a TWL model.
#' 
#' @name misaligned_mat
#' @docType data
#'
#' @usage data(data_and_output)
#'
#' @format A list of matrices
#'
#' @keywords datasets
#'
#' @source simulated
#'
#' @examples
#' data(data_and_output)
#' ls()
"misaligned_mat"


#' Progressively misaligned cluster annotation
#'
#' Example annotation information for simulated 
#' data of progressively misaligned clusters
#' 
#' @name misaligned
#' @docType data
#'
#' @usage data(data_and_output)
#'
#' @format A list of data.tables
#'
#' @keywords datasets
#'
#' @source simulated
#'
#' @examples
#' data(data_and_output)
#' ls()
"misaligned"



#' Output samples
#'
#' 5000 iterations from output of TWLsample function
#' 
#' @name clus_save
#' @docType data
#'
#' @usage data(data_and_output)
#'
#' @format A list of data.tables
#'
#' @keywords datasets
#'
#' @source output of TWLsample function
#'
#' @examples
#' data(data_and_output)
#' ls()
"clus_save"



#' Output PSMs
#'
#' Posterior similar matrices, output of pairwise_clus function
#' 
#' @name outpu_new
#' @docType data
#'
#' @usage data(data_and_output)
#'
#' @format A list of matrices
#'
#' @keywords datasets
#'
#' @source output of pairwise_clus function
#'
#' @examples
#' data(data_and_output)
#' ls()
"outpu_new"

