% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_message_tbl.R
\name{tw_message_tbl}
\alias{tw_message_tbl}
\title{Make a Data Frame from a Messages List}
\usage{
tw_message_tbl(messages_list)
}
\arguments{
\item{messages_list}{An S3 object with the class \code{twilio_messages_list}. Likely
the result of a call to \code{\link{tw_get_messages_list}}.}
}
\value{
A data frame.
}
\description{
Useful for turning a \code{twilio_messages_list} into a tidy data set.
}
\examples{
\dontrun{

# Set API credentials
# You only need to do this once per R session
Sys.setenv(TWILIO_SID = "M9W4Ozq8BFX94w5St5hikg7UV0lPpH8e56")
Sys.setenv(TWILIO_TOKEN = "483H9lE05V0Jr362eq1814Li2N1I424t")

# Get messages sent to your account
messages <- tw_get_messages_list()

# Create data frame from log
sms_data <- tw_message_tbl(messages)

}
}

