% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_twig_obj.R
\name{states}
\alias{states}
\title{Add Markov states to a twig}
\usage{
states(names, init_probs, max_cycles = NULL)
}
\arguments{
\item{names}{... a character vector of Markov state names. They don't need to be included in quotes.}

\item{init_probs}{... a vector of initial probs, these could be numeric or function names.
The functions can depend on the decision and variables in the params list of dataframe.
One of these can be leftover for the remaining probability in that event.
init_probs must have the same length as state names.}

\item{max_cycles}{... optional max tunnel lenghts (tunnel length). This defines the duration allowable in each state.
If ignored a length of 1 is assumed. #' max_cycles if provided must have the same length as state names.}
}
\value{
a twig layer with Markov state names
}
\description{
Add Markov states to a twig
}
\examples{
states(names = c(H,S,D), 
                 init_probs = c(0.5, prob_fun, leftover),
                 max_cycles = c(1, 2, 1)) 
}
