% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{create.baseline}
\alias{create.baseline}
\title{create.baseline}
\usage{
create.baseline(
  dat,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  outcome.names = NULL
)
}
\arguments{
\item{dat}{A data frame or data table structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat,
used to track subjects across multiple rows of data.}

\item{t1.name}{The character name of the time variable within dat that
represents the left endpoints (start of the observation interval).}

\item{t2.name}{The character name of the time variable within dat that
represents the right endpoints (end of the observation interval).}

\item{outcome.names}{A character vector of outcome variable names from dat,
expected to be binary. The function identifies the first occurrence of each
outcome being 1 for each unique id.}
}
\value{
Returns a data frame or data table (depending on the input type) representing
the baseline cohort of the provided panel data. This output is essentially a snapshot
of the data at the initial time point (t=0). The function extracts and formats this
baseline information based on the specified id, time, and outcome variables. The resulting
dataset provides a foundation for subsequent analyses, particularly for tracking the
onset or occurrence of specified outcomes from the start of the observation period.
}
\description{
Creates a baseline cohort from panel data at the initial time point (t=0).
This function is tailored for scenarios where the baseline information is critical,
particularly when the outcomes are considered in terms of the time elapsed since the baseline.
For time points other than the baseline, consider using the function `cross.sectional.data()`.
}
