% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsriadditive.R
\name{summary.tsriadditive}
\alias{summary.tsriadditive}
\alias{print.summary.tsriadditive}
\title{Summarizing Additive Hazards Model with Two Stage Residual Inclusion Method Fits}
\usage{
\method{summary}{tsriadditive}(object, ...)

\method{print}{summary.tsriadditive}(x, ...)
}
\arguments{
\item{object}{an object of class "tsriadditive", usually, a result of a call to tsriadditive.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.tsriadditive", usually, a result of a call to summary.tsriadditive.}
}
\value{
print.summary.lm tries to be smart about formatting coefficients, an estimated variance covariance matrix of
the coeffieients, Z-values and the corresponding P-values
}
\description{
summary method for class "tsriadditive".
}
\examples{
survtime <- rexp(100)
cause <- rbinom(100, 1, 0.7)
treatment <- rbinom(100, 1, 0.5)
IV <- rnorm(100)
covariates <- rnorm(100)
fit <- tsriadditive(survtime, cause, treatment, IV, covariates)
summary(fit)
}
