% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{gdp}
\alias{gdp}
\title{Gross Domestic Product and Agriculture Value Added}
\format{
list of time series.
}
\source{
\href{https://www.fao.org/faostat/en/#data/MK}{FAOSTAT Macro Indicators Database}
}
\usage{
data(gdp)
}
\description{
Summary of global and regional trends in GDP and agriculture value.
Data Type: macroeconomic indicators. Category:	Economy. Creation Date	2024.
}
\examples{
# Load GDP list and plot one series
data(gdp)
# gdp <- loadfulldata(gdp)
series <- gdp[[1]]
ts.plot(series, ylab = "US$", xlab = "Year", main = "GDP example")
}
\references{
FAO. 2024. Gross domestic product and agriculture value added 2013–2022 – Global and regional trends.
FAOSTAT Analytical Briefs, No. 85. Rome. \doi{10.4060/cd0763en}
}
\keyword{datasets}
