% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.tsmodel.distribution}
\alias{plot.tsmodel.distribution}
\alias{tsmodel.distribution}
\alias{tsmodel.predict}
\alias{plot.tsmodel.predict}
\title{Plots of predictive distributions}
\usage{
\method{plot}{tsmodel.distribution}(
  x,
  y = NULL,
  median_color = "black",
  median_type = 1,
  median_width = 3,
  interval_quantiles = c(0.025, 0.975),
  gradient_color = "steelblue",
  interval_color = "cyan",
  interval_type = 2,
  interval_width = 2,
  ylim = NULL,
  ylab = "",
  n_x = NCOL(x),
  x_axes = TRUE,
  add = FALSE,
  zero_out = FALSE,
  date_class = "Date",
  ...
)

\method{plot}{tsmodel.predict}(
  x,
  y = NULL,
  plot_original = TRUE,
  median_color = "black",
  median_type = 1,
  median_width = 3,
  interval_quantiles = c(0.025, 0.975),
  gradient_color = "steelblue",
  interval_color = "cyan",
  interval_type = 2,
  interval_width = 2,
  ylim = NULL,
  ylab = "",
  n_original = NULL,
  x_axes = TRUE,
  zero_out = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \dQuote{tsmodel.distribution} or \dQuote{tsmodel.predict}.}

\item{y}{not used.}

\item{median_color}{the color used for plotting the median value.}

\item{median_type}{the line type for the median.}

\item{median_width}{the width of the median line.}

\item{interval_quantiles}{the quantiles to include in the plot.}

\item{gradient_color}{the gradient color to use for the distribution.}

\item{interval_color}{the color of the quantile lines.}

\item{interval_type}{the line type for the quantiles.}

\item{interval_width}{the width of the quantile lines.}

\item{ylim}{user specified limits for the y-axis.}

\item{ylab}{user specified label for y-axis.}

\item{n_x}{the number of time periods from the end to plot for x.}

\item{x_axes}{whether to print the x-axis (usually time/date).}

\item{add}{whether to overlay another \dQuote{tsmodel.distribution} on top 
of a current plot. This will only plot the median and quantiles and not the full 
distribution with gradient color.}

\item{zero_out}{whether to zero any negative value in the prediction intervals.}

\item{date_class}{when overlaying (add argument) one distribution 
(\dQuote{tsmodel.distribution} on top of another, particularly if it is added 
to a plot based on \dQuote{tsmodel.predict}, then in order for this to work 
correctly the two date classes have to be the same. The \dQuote{tsmodel.predict} 
plot method infers the class from the original time series which is contained in 
the object. Since the \dQuote{tsmodel.distribution} carries no additional 
information other than the column names of the date/time stamps, then it is 
upto the user to supply what this should be.}

\item{...}{additional arguments to the plot.default function.}

\item{plot_original}{whether to include the original dataset in the plot.}

\item{n_original}{the number of time periods from the end to plot for the 
original series. Defaults to plotting the whole series.}
}
\value{
a plot of the predicted distribution.
}
\description{
Plots for objects generated from probabilistic models returning 
a forecast distribution.
}
\note{
Any matrix representing a distribution of values at points in time, 
with time in the columns (date labels in columns) and the distribution in rows 
can be set to class \dQuote{tsmodel.distribution} and then passed to the plot 
function which can generate a nice distribution plot. The \dQuote{tsmodel.predict} 
is a list with the posterior predictive (or simulated) distribution 
(the \dQuote{tsmodel.distribution}) in addition to the original series 
(original.series) of class zoo or xts.
}
\examples{
library(xts)
months <- c("01","02","03","04","05","06","07","08","09","10","11","12")
dates <- as.Date(paste0(sort(rep(1973:1978, 12)),"-",rep(months, 6), "-",rep("01",12*6)))
y <- xts(as.numeric(USAccDeaths), dates)
samples <- do.call(cbind, lapply(1:12, 
function(i){sample(as.numeric(y[format(index(y),"\%m") == months[i]]), 100, replace = TRUE)}))
predict_dates <- as.Date(paste0(rep(1979, 12),"-",months, "-",rep("01",12)))
expected_value <- colMeans(samples)
p <- list()
colnames(samples) <- as.character(predict_dates)
class(samples) <- "tsmodel.distribution"
p$original_series <- y
p$distribution <- samples
p$mean <- xts(expected_value, predict_dates)
class(p) <- "tsmodel.predict"
actuals_available <- c(7798,7406,8363,8460,9217,9316)
plot(p, main = "USAccDeaths Resample Based Forecast", n_original = 12*3, 
gradient_color = "orange", interval_color = "deepskyblue", median_width = 1.5)
points(predict_dates[1:6], actuals_available, col = "green", cex = 1.5)
}
