% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_forecast}
\alias{plot_forecast}
\title{Plots forecast and realised values of the log cumulative growth rate}
\usage{
plot_forecast(
  res,
  y.eval,
  n.ahead = 14,
  plt.start.date = NULL,
  title = "",
  caption = ""
)
}
\arguments{
\item{res}{Results object estimated using the \code{estimate()} method.}

\item{y.eval}{The out-of-sample realisation of the log growth rate of the
cumulated variable (i.e. the actual values to which the forecasts should
be compared).}

\item{n.ahead}{The number of time periods ahead from the end of the sample
to be forecast. The default is 14.}

\item{plt.start.date}{Plot start date. Default is \code{NULL} which is the
start of the estimation sample.}

\item{title}{Plot title. Enter as text string.}

\item{caption}{Plot caption. Enter as text string.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plots actual and filtered values of the log cumulative growth
rate (\eqn{\ln(g_t)}) in the estimation sample and the forecast and realised
log cumulative growth rate out of the estimation sample.
}
\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-20")
idx.eval <- (zoo::index(gauteng) >= as.Date("2020-07-20")) &
     zoo::index(gauteng) <= as.Date("2020-07-27")

# Specify a model
model <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)
# Estimate a specified model
res <- model$estimate()

# Plot forecast and realised log growth rate of cumulative cases
plot_forecast(res, y.eval = df2ldl(gauteng[idx.eval]), n.ahead = 7,
  title = "Forecast ln(g)", plt.start.date = as.Date("2020-07-13"))

}
