% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spd.R
\name{dspd}
\alias{dspd}
\alias{pspd}
\alias{qspd}
\alias{rspd}
\title{Semi-Parametric Distribution}
\usage{
dspd(x, object, linear = TRUE, log = FALSE)

pspd(q, object, linear = TRUE, lower_tail = TRUE)

qspd(p, object, linear = TRUE, lower_tail = TRUE)

rspd(n, object, linear = TRUE)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{object}{an object of class \dQuote{tsdistribution.spdestimate} returned
from calling \code{\link{estimate.tsdistribution.spdspec}}.}

\item{linear}{logical, if TRUE (default) interior smoothing function uses linear 
interpolation rather than constant.}

\item{log}{(logical) if TRUE, probabilities p are given as log(p).}

\item{lower_tail}{if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{Number of observations.}
}
\value{
d gives the density, p gives the distribution function, q gives the quantile function
and r generates random deviates. Output depends on x or q length, or n for the random number
generator.
}
\description{
Density, distribution, quantile function and random number
generation for the semi parametric distribution (spd) which has generalized
Pareto tails and kernel fitted interior.
}
