% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{add_seasonal}
\alias{add_seasonal}
\alias{add_seasonal.issm.component}
\title{Seasonal Trend Component}
\usage{
add_seasonal(x, ...)

\method{add_seasonal}{issm.component}(
  x,
  frequency = 12,
  gamma = 0.01,
  s0 = NULL,
  init_harmonics = frequency/2,
  normalized_seasonality = TRUE,
  init_scale = 1,
  ...
)
}
\arguments{
\item{x}{an object of class issm.component or other supported class.}

\item{...}{additional parameters.}

\item{frequency}{seasonal frequency.}

\item{gamma}{the decay coefficient on the error of the seasonal component}

\item{s0}{a vector of length frequency - 1 for the initial seasonal component.}

\item{init_harmonics}{number of harmonics to initialize s0 when this is not provided.}

\item{normalized_seasonality}{whether normalize the seasonal component based on the
method of Roberts and McKenzie. This is applied only to a single seasonal frequency.}

\item{init_scale}{the scaling multiplier for s0 (when this is not provided).}
}
\value{
An object of class issm.component updated with the seasonal
component.
}
\description{
Seasonal Trend Component
}
