% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_13.R
\name{seqic_indicator_13}
\alias{seqic_indicator_13}
\title{SEQIC Indicator 13 – Validation of  Trauma Registry Records}
\usage{
seqic_indicator_13(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id,
  validity_score,
  validity_threshold = 85,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{validity_score}{Numeric. The proportion of each trauma registry record
that is valid, expressed as a percentage (0–100). Typically calculated by
the registry system.}

\item{validity_threshold}{Numeric. The minimum acceptable validity percentage
threshold for records to be counted in the numerator. Defaults to \code{85}.}

\item{groups}{Additional columns passed as a vector of strings to
\code{dplyr::summarize()} via the \code{.by} argument for grouped summaries. Defaults
to \code{NULL}.}

\item{calculate_ci}{If \code{NULL}, 95\% confidence intervals will not be
calculated for the performance estimates.  Otherwise, options of "wilson"
or "clopper-pearson" can be supplied to utilize the corresponding methods
to calculate the confidence intervals for the proportions. Defaults to
\code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A tibble summarizing SEQIC Indicator 13 results. Includes numerator,
denominator, and performance rate 95\% confidence intervals are included if
requested.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates the proportion of trauma records that meet or exceed
a threshold for data validity among facilities at the specified trauma center
levels. Optionally computes confidence intervals.
}
\details{
This function:
\itemize{
\item Filters to include only patients treated at trauma centers with
levels specified in \code{included_levels} (default: Levels I–IV).
\item Deduplicates the dataset using \code{unique_incident_id} to ensure each
incident is counted only once.
\item Flags records with a \code{validity_score} greater than or equal to the
specified \code{validity_threshold} threshold (default: 85).
\item Calculates the proportion of valid records among all included
records.
\item Optionally calculates binomial confidence intervals using the method
specified in \code{calculate_ci} via \code{nemsqa_binomial_confint()}.
\item Adds a "Population/Sample" label unless grouping is applied via
\code{groups}.
}

Users must ensure that appropriate column names are passed using tidy
evaluation (bare column names) and that the input data has been cleaned and
includes no missing or malformed identifiers, trauma level classifications,
or validity scores.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Simulated data for SEQIC Indicator 13
test_data <- tibble::tibble(
  id = as.character(1:12),
  trauma_level = c("I", "II", "III", "IV", "I", "II", "III", "IV", "I", "II",
  "III", "IV"),
  validity = c(90, 80, 88, 92, 86, 75, 89, 70, 95, 85, 83, 87)
)

# Run the function
traumar::seqic_indicator_13(
  data = test_data,
  level = trauma_level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id = id,
  validity_score = validity,
  validity_threshold = 85,
  calculate_ci = "wilson"
)

}
\author{
Nicolas Foss, Ed.D., MS
}
