% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver.R
\name{ukeld_US}
\alias{ukeld_US}
\title{UKELD score (US units)}
\usage{
ukeld_US(INR, bili, creat, Na)
}
\arguments{
\item{INR}{numeric vector of INR}

\item{bili}{numeric vector of bilirubin in mg/dl}

\item{creat}{numeric vector of creatinine in mg/dl}

\item{Na}{numeric vector of sodium in mmol/l}
}
\value{
UKELD score
}
\description{
A vectorised function to calculate the UKELD score using US units for bilirubin and creatinine.
}
\details{
Reference: Barber KM, Madden S, Allen J, et al. Elective liver transplant list mortality:
development of a United Kingdom end-stage liver disease score. Transplantation
2011; 92(4):469-76.
}
\examples{
ukeld_US(INR = 2.0, bili = 1.8, creat = 170, Na = 130)
}
