% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_m.R
\name{trans_m}
\alias{trans_m}
\title{Regression Analysis of Right-censored Data using Semiparametric
 Transformation Models.}
\usage{
trans_m(
  X,
  delta,
  Y,
  plot.Lamb = TRUE,
  alpha = seq(0.1, 1.1, by = 0.1),
  trsmodel = TRUE,
  EM_itmax = 250,
  show_res = TRUE
)
}
\arguments{
\item{X}{design matrix}

\item{delta}{censoring indicator. If \eqn{Y_i} is censored, \code{delta}=0. If
not, \code{delta}=1.}

\item{Y}{observed event times}

\item{plot.Lamb}{If TRUE, plot the estimated baseline cumulative hazard
function and confidence intervals. The default is TRUE.}

\item{alpha}{parameter in transformation function. Generally, \eqn{\alpha} can
not be observed in medical applications. In that situation, \code{alpha}
indicates the scale of choosing \eqn{\alpha}. The default is
\eqn{(0.1,0.2,...,1.1)}. If \eqn{\alpha} is known, \code{alpha} indicates
the true value of \eqn{\alpha}.}

\item{trsmodel}{logical value indicating whether to implement transformation
models. The default is TRUE.}

\item{EM_itmax}{maximum iteration of EM algorithm. Defaults to 250.}

\item{show_res}{show results after \code{trans_m}.}
}
\value{
a list containing \tabular{lccl}{ \code{beta.est } \tab\tab\tab
 estimators of \eqn{\beta} \cr \code{SE.beta } \tab\tab\tab standard errors
 of the estimated \eqn{\beta} \cr \code{SE.Ydot} \tab\tab\tab standard errors
 of the estimated \eqn{\Lambda(Y')} \cr \code{Ydot} \tab\tab\tab vector of
 sorted event times with duplicate values removed   \cr \code{Lamb.est}
 \tab\tab\tab estimated baseline cumulative hazard  \cr \code{lamb.est}
 \tab\tab\tab estimated jump sizes of baseline cumulative hazard function \cr
 \code{choose.alpha } \tab\tab\tab the chosen \eqn{\alpha} \cr
 \code{Lamb.upper} \tab\tab\tab upper confidence limits for the estimated
 baseline cumulative hazard function \cr \code{Lamb.lower} \tab\tab\tab lower
 confidence limits for the estimated baseline cumulative hazard function \cr
 \code{p.beta} \tab\tab\tab P values of estimated \eqn{\beta} \cr
 \code{p.Lamb} \tab\tab\tab P values of estimated baseline cumulative hazard
 \cr p.beta }
}
\description{
This function is used to conduct the regression analysis of
 right-censored data using semiparametric transformation models. It
 calculates the estimators, standard errors and p values. A plot of estimated
 baseline cumulative hazard function and confidence intervals can be
 produced.
}
\details{
If \eqn{\alpha} is unknown, we firse set \eqn{\alpha=}\code{alpha}.
 Then, for each \eqn{\alpha}, we estimate the parameters and record the value
 of observed log-likelihood function. The \eqn{\alpha} that maximizes the
 observed log-likelihood function and the corresponding \eqn{\hat\beta} and
 \eqn{\hat\Lambda(\cdot)} are chosen as the best estimators. Nonparametric
 maximum likelihood estimators are developed for the regression parameters
 and cumulative intensity functions of these models based on censored data.
}
\examples{
 gen_data = generate_data(200, 1, 0.5, c(-0.5,1))
 delta = gen_data$delta
 Y = gen_data$Y
 X = gen_data$X
 res.trans = trans_m(X, delta,  Y, plot.Lamb = TRUE, show_res = FALSE)


}
\references{
Cheng, S.C., Wei, L.J., and Ying, Z. (1995). Analysis of
 transformation models with censored data. Biometrika 82, 835-845.

 Zeng, D. and Lin, D.Y. (2007). Maximum likelihood estimation in
 semiparametric regression models with censored data. J. R. Statist. Soc. B
 69, 507-564.

 Abramowitz, M., and Stegun, I.A. (1972). Handbook of Mathematical Functions
 (9th ed.). Dover Publications, New York.

 Evans, M. and Swartz, T. (2000). Approximating Integrals via Monte Carlo and
 Deterministic Methods. Oxford University Press.

 Liu, Q. and Pierce, D.A. (1994). A note on Gauss-Hermite quadrature.
 Biometrika 81, 624-629.

 Louis, T. (1982). Finding the Observed Information Matrix when Using the EM
 Algorithm. Journal of the Royal Statistical Society. Series B
 (Methodological), 44(2), 226-233.
}
\seealso{
\code{\link{EM_est}}
}
