% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_functions.R
\name{extract_repeat_correction_summary}
\alias{extract_repeat_correction_summary}
\title{Extract repeat correction summary}
\usage{
extract_repeat_correction_summary(fragments_list)
}
\arguments{
\item{fragments_list}{A list of fragments class objects obtained from the \code{\link[=call_repeats]{call_repeats()}} function when the \code{correction = "repeat"} parameter is used.}
}
\value{
A data.frame
}
\description{
Extracts a table summarizing the model used to correct repeat length
}
\details{
For each of the samples used for repeat correction, this table pulls out the modal repeat length called by the model (\code{allele_repeat}), how far that sample is on average from the linear model in repeat units by finding the average residuals (\code{avg_residual}), and the absolute value of the \code{avg_residual} (\code{abs_avg_residual})
}
\examples{
fsa_list <- lapply(cell_line_fsa_list, function(x) x$clone())
# import data with read_fsa() to generate an equivalent list to cell_line_fsa_list
test_fragments <- trace(
   fsa_list, 
   grouped = TRUE, 
   metadata_data.frame = metadata, 
   correction = "repeat",
   show_progress_bar = FALSE
)

# finally extract repeat correction summary
extract_repeat_correction_summary(test_fragments)


}
