% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_validate.R
\name{format_toon}
\alias{format_toon}
\title{Format/pretty-print TOON}
\usage{
format_toon(
  x,
  is_file = FALSE,
  indent = 2L,
  canonical = FALSE,
  allow_comments = TRUE
)
}
\arguments{
\item{x}{Character scalar containing TOON text, or file path if is_file=TRUE.}

\item{is_file}{Logical. If TRUE, x is treated as a file path.}

\item{indent}{Integer. Number of spaces for indentation (default 2).}

\item{canonical}{Logical. If TRUE, use stable representation with
lexicographic key ordering. Default FALSE (preserve original order).}

\item{allow_comments}{Logical. If TRUE (default), allow comments in input.}
}
\value{
Character scalar with formatted TOON. If is_file=TRUE, returns
formatted text (does not rewrite file).
}
\description{
Format/pretty-print TOON
}
\examples{
# Format with default indent
format_toon('name:"Alice"')

# Format with canonical key ordering
format_toon('b: 1\na: 2', canonical = TRUE)

}
