% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_of_rank.R
\name{variance_of_rank}
\alias{variance_of_rank}
\title{variance of rank}
\usage{
variance_of_rank(data, trait, genotype, environment, unit.correct = FALSE)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.#'}
}
\value{
a data table with variance of rank
}
\description{
\code{variance_of_rank} calculate variance of a genotype across environments.
}
\details{
Variance of rank (Nassar and Huehn, 1987) is calculatd based on regression function.
Variety with low variance of rank is considered as stable.
Equation of variance of rank can be found in vignette file.
}
\examples{
data(Data)
variance.of.rank <- variance_of_rank(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment",
 unit.correct = FALSE)
}
\references{
\insertRef{nassar1987}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{approach}
\keyword{nonparametric}
