% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_deterministic.R
\name{impute_deterministic}
\alias{impute_deterministic}
\title{Model-free imputation via deterministic sampling}
\usage{
impute_deterministic(dat, reason, impute, npts, J, seed)
}
\arguments{
\item{dat}{data.frame containing at least 5 columns: TRT01P (treatment arm as factor), AVAL (survival time), EVENT (event indicator), CNSRRS (censoring reason) and MAXAVAL (maximum potential survival time, duration between randomization to data cut-off)}

\item{reason}{a string specifying the censoring reasons which require imputation. It must be one of the reasons from variable CNSRRS.}

\item{impute}{a string specifying the treatment arm(s) which require imputation. It must be one of the arms from variable TRT01P, the first level of TRT01P is considered as the control arm.}

\item{npts}{number of patients to be imputed}

\item{J}{numeric indicating number of imputations.}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
a list of data.frame from each imputation with imputed AVAL and EVENT, where original variables are kept as AVAL and EVENT.
}
\description{
patients will be assigned deterministically an event time at the time of censoring  or extend the censoring time to the potential maximum follow-up of each patient.
}
\details{
patients will be assigned deterministically an event time at the time of censoring  or extend the censoring time to the potential maximum follow-up of each patient.
}
\keyword{internal}
