% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_tidytemplate.R
\name{use_tidytemplate}
\alias{use_tidytemplate}
\title{Create and open the tidytemplate}
\usage{
use_tidytemplate(
  name = NULL,
  open = rlang::is_interactive(),
  refdate = today(),
  ignore = FALSE
)
}
\arguments{
\item{name}{A name for your generated TidyTuesday analysis Rmd, such as
"My_TidyTuesday.Rmd".}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{refdate}{Date to use as reference to determine which TidyTuesday to use
for the template. Either date object or character string in YYYY-MM-DD
format.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}
}
\value{
A logical vector indicating whether the file was created or
modified, invisibly.
}
\description{
Use the tidytemplate Rmd for starting your analysis with a leg up for
processing
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  use_tidytemplate(name = "My_Awesome_TidyTuesday.Rmd")
\dontshow{\}) # examplesIf}
}
