% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_diff.R
\name{spec_diff}
\alias{spec_diff}
\title{Apply Differentiation to Spectral Data}
\usage{
spec_diff(.data, wn_col = NULL, degree = 1)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}

\item{degree}{A numeric value specifying the degree of differentiation. If `degree` is 0, the original data is returned without any changes.}
}
\value{
A `tibble` with the differentiated spectral data, containing the wavelength column and the differentiated numeric columns. If `degree` is 0, the original data is returned.
}
\description{
This function applies numerical differentiation to spectral data, allowing for the calculation of the first or higher-order differences.
}
