% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{tidyllm_tool}
\alias{tidyllm_tool}
\title{Create a Tool Definition for tidyllm}
\usage{
tidyllm_tool(.f, .description = character(0), ...)
}
\arguments{
\item{.f}{The function to wrap as a tool}

\item{.description}{Character string describing what the tool does}

\item{...}{Named arguments providing schema definitions for each function parameter using tidyllm_fields}
}
\value{
A \code{TOOL} class object that can be used with tidyllm \code{chat()} functions
}
\description{
Creates a tool definition for use with Language Model API calls that support function calling.
This function wraps an existing R function with schema information for LLM interaction.
}
\details{
Each parameter schema in \code{...} should correspond to a parameter in the wrapped function.
All required function parameters must have corresponding schema definitions.
}
\examples{
get_weather <- function(location){}
weather_tool <- tidyllm_tool(
  get_weather,
  "Get the current weather in a given location",
  location = field_chr("The city and state, e.g., San Francisco, CA")
)

}
