% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-dbscan.R
\name{tidy_dbscan}
\alias{tidy_dbscan}
\title{Tidy DBSCAN Clustering}
\usage{
tidy_dbscan(data, eps, minPts = 5, cols = NULL, distance = "euclidean")
}
\arguments{
\item{data}{A data frame, tibble, or distance matrix}

\item{eps}{Neighborhood radius (epsilon)}

\item{minPts}{Minimum number of points to form a dense region (default: 5)}

\item{cols}{Columns to include (tidy select). If NULL, uses all numeric columns.}

\item{distance}{Distance metric if data is not a dist object (default: "euclidean")}
}
\value{
A list of class "tidy_dbscan" containing:
\itemize{
\item clusters: tibble with observation IDs and cluster assignments (0 = noise)
\item core_points: logical vector indicating core points
\item n_clusters: number of clusters (excluding noise)
\item n_noise: number of noise points
\item model: original dbscan object
}
}
\description{
Performs density-based clustering with tidy output
}
\examples{
# Basic DBSCAN
db_result <- tidy_dbscan(iris, eps = 0.5, minPts = 5)

# With suggested eps from k-NN distance plot
eps_suggestion <- suggest_eps(iris, minPts = 5)
db_result <- tidy_dbscan(iris, eps = eps_suggestion$eps, minPts = 5)

}
