% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{calculate_diagnostics}
\alias{calculate_diagnostics}
\title{Calculate diagnostics}
\usage{
calculate_diagnostics(data, treatment, outcome, .diag.cfg)
}
\arguments{
\item{data}{Data frame with all additional columns (such as model predictions) included.}

\item{treatment}{Unquoted treatment variable name}

\item{outcome}{Unquoted outcome variable name}

\item{.diag.cfg}{\code{Diagnostics_cfg} object}
}
\value{
Returns a tibble with columns:
\itemize{
\item \code{estimand} - Character indicating the diagnostic that was calculated
\item \code{level} - Indicates the scope of this diagnostic (e.g. does it apply
only to the model of the outcome under treatment).
\item \code{term} - Indicates a more granular descriptor of what the value is for,
such as the specific model within the SuperLearner ensemble.
\item \code{estimate} - Point estimate of the diagnostic.
\item \code{std_error} - Standard error of the diagnostic.
}
}
\description{
This function calculates the diagnostics requested by the \code{Diagnostics_cfg} object.
}
\seealso{
\link{Diagnostics_cfg}
}
\keyword{internal}
