% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cfg.R
\name{MCATE_cfg}
\alias{MCATE_cfg}
\title{Configuration of Marginal CATEs}
\description{
\code{MCATE_cfg} is a configuration class for estimating marginal response
surfaces based on heterogeneous treatment effect estimates. "Marginal"
in this context implies that all other covariates are marginalized.
Thus, if two covariates are highly correlated, it is likely that their
MCATE surfaces will be extremely similar.
}
\examples{
MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))

## ------------------------------------------------
## Method `MCATE_cfg$new`
## ------------------------------------------------

MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))

## ------------------------------------------------
## Method `MCATE_cfg$add_moderator`
## ------------------------------------------------

cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
cfg <- cfg$add_moderator("x2", KernelSmooth_cfg$new(neval = 100))
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cfgs}}{Named list of covariates names to a \code{Model_cfg} object defining
how to present that covariate's CATE surface (while marginalizing
over all other covariates).}

\item{\code{std_errors}}{Boolean indicating whether the results should be
returned with standard errors or not.}

\item{\code{estimand}}{String indicating the estimand to target.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MCATE_cfg-new}{\code{MCATE_cfg$new()}}
\item \href{#method-MCATE_cfg-add_moderator}{\code{MCATE_cfg$add_moderator()}}
\item \href{#method-MCATE_cfg-clone}{\code{MCATE_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCATE_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-MCATE_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{MCATE_cfg} object with specified model name and hyperparameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCATE_cfg$new(cfgs, std_errors = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cfgs}}{Named list from moderator name to a \code{Model_cfg} object
defining how to present that covariate's CATE surface (while
marginalizing over all other covariates)}

\item{\code{std_errors}}{Boolean indicating whether the results should be returned with standard
errors or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{MCATE_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCATE_cfg-add_moderator"></a>}}
\if{latex}{\out{\hypertarget{method-MCATE_cfg-add_moderator}{}}}
\subsection{Method \code{add_moderator()}}{
Add a moderator to the \code{MCATE_cfg} object. This entails defining a configuration
for displaying the effect surface for that moderator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCATE_cfg$add_moderator(var_name, cfg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var_name}}{The name of the moderator to add (and the name of the column in
the dataset).}

\item{\code{cfg}}{A \code{Model_cfg} defining how to display the selected moderator's effect
surface.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated \code{MCATE_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
cfg <- cfg$add_moderator("x2", KernelSmooth_cfg$new(neval = 100))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCATE_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MCATE_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCATE_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
