% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-utils.R
\name{HTEFold}
\alias{HTEFold}
\title{R6 class to represent partitions of the data between training and held-out}
\description{
R6 class to represent partitions of the data between training and held-out

R6 class to represent partitions of the data between training and held-out
}
\details{
This takes a set of folds calculated elsewhere and represents
these folds in a consistent format.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{train}}{A dataframe containing only the training set}

\item{\code{holdout}}{A dataframe containing only the held-out data}

\item{\code{in_holdout}}{A logical vector indicating if the initial data
lies in the holdout set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HTEFold-new}{\code{HTEFold$new()}}
\item \href{#method-HTEFold-clone}{\code{HTEFold$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTEFold-new"></a>}}
\if{latex}{\out{\hypertarget{method-HTEFold-new}{}}}
\subsection{Method \code{new()}}{
Creates an R6 object of the data split between training and test set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTEFold$new(data, split_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The dataset to be split}

\item{\code{split_id}}{An identifier indicating which data should lie in the holdout set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class \code{HTEFold}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTEFold-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HTEFold-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTEFold$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
