% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart.R
\name{line_chart}
\alias{line_chart}
\title{Generates a line plot with markers on chosen points. Allows only one point per time interval. To create a plot with many points within one time interval try `line_chart_dense`.}
\usage{
line_chart(
  data,
  x,
  series,
  series_labels,
  ser_names,
  point_cords,
  interval = "months"
)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{x}{vector containing time intervals of the values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{ser_names}{vector containing column names of a value to be marked}

\item{point_cords}{vector of the same length as ser_names containing numerical values of indexes in data of values to be marked}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
Generates a line plot with markers on chosen points. Allows only one point per time interval. To create a plot with many points within one time interval try `line_chart_dense`.
}
\examples{

#preparing the data frame
data <- data.frame(
time = c(2015, 2016, 2017, 2018, 2019, 2020),
Gamma = c(98, 80, 16, 25, 55, 48),
Delta = c(22, 25, 67, 73, 102, 98)
)

#defining rest of arguments
names <- c("Gamma", "Gamma", "Gamma","Gamma","Delta", "Delta")
cords <- c(1, 4,5,2, 5,4)

#generating SVG string
line_chart  <- line_chart(
  data = data,
  x = data$time,
  series = c("Gamma", "Delta"),
  series_labels =c("Gamma inc.", "Delta inc."),
  ser_names = names,
  point_cords = cords,
  interval = "years")

#showing the plot
line_chart

}
