% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_charts.R
\name{join_charts}
\alias{join_charts}
\title{Join SVG charts.}
\usage{
join_charts(
  ...,
  nrows = max(length(list(...)), length(list_of_plots)),
  ncols = 1,
  list_of_plots = NULL
)
}
\arguments{
\item{...}{multiple character vectors with SVG content}

\item{nrows}{number of rows of plots in joint plot, default is set to number of plots}

\item{ncols}{number of columns of plots in joint plot, default is set to 1}

\item{list_of_plots}{optional list of plots to join. Use exclusively ... params or list_of_plots. Names of list entries will be plotted as titles of the plots}
}
\value{
object of class tidychart with a character vector containing SVG elements
}
\description{
This function first populates each place in the first row, then columns in the second row.
}
\examples{
  df <- data.frame(
   mon = month.abb[1:6],
   values = rnorm(6)
  )

join_charts(
  column_chart(df, x = 'mon', series = 'values'),
  column_chart(df, x = 'mon', series = 'values')
)
}
