% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-join.R
\name{validate_join}
\alias{validate_join}
\alias{print.validate_join}
\alias{summary.validate_join}
\title{Validate Join Operations Between Two Tables}
\usage{
validate_join(x, y, by = NULL, stat = NULL, stat_x = NULL, stat_y = NULL)

\method{print}{validate_join}(x, ...)

\method{summary}{validate_join}(object, ...)
}
\arguments{
\item{x}{A data.frame or tibble (left table).}

\item{y}{A data.frame or tibble (right table).}

\item{by}{A character vector of column names to join on. Use a named vector
\code{c("key_x" = "key_y")} when column names differ between tables. Unnamed
elements are used for both tables.}

\item{stat}{Optional single column name (string) to track in both tables when
the column name is the same. Ignored if \code{stat_x} or \code{stat_y} is provided.}

\item{stat_x}{Optional column name (string) for a numeric statistic in \code{x}.}

\item{stat_y}{Optional column name (string) for a numeric statistic in \code{y}.}

\item{...}{Additional arguments (currently unused).}

\item{object}{A \code{validate_join} object to summarize.}
}
\value{
An S3 object of class \code{validate_join} containing:
\describe{
\item{x_name, y_name}{Names of the input tables from the original call}
\item{by_x, by_y}{Key columns used for the join}
\item{counts}{List with row counts, match rates, and overlap statistics}
\item{stat}{When \code{stat}, \code{stat_x}, or \code{stat_y} is provided, a list with
stat diagnostics per table. \code{NULL} when no stat is provided.}
\item{duplicates}{List with duplicate key information for each table}
\item{summary_table}{A data.frame summarizing the join diagnostics}
\item{relation}{Character string describing the relationship}
\item{keys_only_in_x}{Unmatched keys from x}
\item{keys_only_in_y}{Unmatched keys from y}
}
}
\description{
Analyzes a potential join between two data.frames or tibbles without
performing the full join. Reports relationship type (one-to-one,
one-to-many, etc.), match rates, duplicate keys, and unmatched rows.
Optionally tracks a numeric statistic column through the join to quantify
impact.
}
\examples{
x <- data.frame(id = c(1L, 2L, 3L, 3L), value = c("a", "b", "c", "d"))
y <- data.frame(id = c(2L, 3L, 4L), score = c(10, 20, 30))
result <- validate_join(x, y, by = "id")
print(result)

# Track a stat column with different names in each table
x2 <- data.frame(id = 1:3, sales = c(100, 200, 300))
y2 <- data.frame(id = 2:4, cost = c(10, 20, 30))
validate_join(x2, y2, by = "id", stat_x = "sales", stat_y = "cost")

}
\seealso{
Other join validation: 
\code{\link{compare_tables}()},
\code{\link{validate_primary_keys}()},
\code{\link{validate_var_relationship}()}
}
\concept{join validation}
