% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-summary.R
\name{get_summary_table}
\alias{get_summary_table}
\title{Generate Summary Table for a Data Frame}
\usage{
get_summary_table(.data, cols = NULL)
}
\arguments{
\item{.data}{A data.frame or tibble to summarize.}

\item{cols}{Optional character vector of column names to summarize. If
\code{NULL} (the default), all columns are summarized.}
}
\value{
A data.frame with one row per column containing summary statistics.
}
\description{
Creates a comprehensive summary of all columns in a data.frame, including
type, missing values, descriptive statistics, and example values.
}
\examples{
df <- data.frame(
  id = 1:100,
  value = rnorm(100),
  category = sample(letters[1:5], 100, replace = TRUE)
)
get_summary_table(df)

}
\seealso{
Other data quality: 
\code{\link{audit_transform}()},
\code{\link{diagnose_nas}()},
\code{\link{diagnose_strings}()},
\code{\link{summarize_column}()}
}
\concept{data quality}
