% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_spacing_class.R
\name{ild_spacing_class}
\alias{ild_spacing_class}
\title{Classify spacing as regular-ish vs irregular-ish}
\usage{
ild_spacing_class(x, cv_threshold = 0.2, pct_gap_threshold = 10)
}
\arguments{
\item{x}{An ILD object (see [is_ild()]).}

\item{cv_threshold}{Numeric. Coefficient of variation of within-person
intervals above which spacing is "irregular-ish" (default 0.2).}

\item{pct_gap_threshold}{Numeric. Percent of intervals flagged as gaps
above which spacing is "irregular-ish" (default 10).}
}
\value{
Character: `"regular-ish"` or `"irregular-ish"`.
}
\description{
Returns a simple classification for use in documentation or when choosing
correlation structure (e.g. AR1 vs CAR1 in [ild_lme()]). The rule is
documented and overridable via arguments. Does not change core ILD behavior.
}
