% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-check-dupe-rows.R
\name{check_duplicate_rows}
\alias{check_duplicate_rows}
\title{Check for Duplicate Rows in a Data Frame}
\usage{
check_duplicate_rows(.data)
}
\arguments{
\item{.data}{A data frame.}
}
\value{
A logical vector indicating whether each row is a duplicate or not.
}
\description{
This function checks for duplicate rows in a data frame.
}
\details{
This function checks for duplicate rows by comparing each row in the
data frame to every other row. If a row is identical to another row, it is
considered a duplicate.
}
\examples{
data <- data.frame(
  x = c(1, 2, 3, 1),
  y = c(2, 3, 4, 2),
  z = c(3, 2, 5, 3)
)

check_duplicate_rows(data)

}
\seealso{
\code{\link{duplicated}}, \code{\link{anyDuplicated}}

Other Utility: 
\code{\link{core_packages}()},
\code{\link{create_splits}()},
\code{\link{create_workflow_set}()},
\code{\link{fast_classification_parsnip_spec_tbl}()},
\code{\link{fast_regression_parsnip_spec_tbl}()},
\code{\link{full_internal_make_wflw}()},
\code{\link{install_deps}()},
\code{\link{load_deps}()},
\code{\link{match_args}()},
\code{\link{quantile_normalize}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
