% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_index.R
\name{grab_index}
\alias{grab_index}
\alias{grab_index.character}
\alias{grab_index.default}
\alias{grab_index.list}
\alias{grab_index.data.frame}
\alias{grab_index.matrix}
\title{Get Elements Matching Between 2 Points}
\usage{
grab_index(x, from = NULL, to = NULL, ...)

\method{grab_index}{character}(x, from = NULL, to = NULL, ...)

\method{grab_index}{default}(x, from = NULL, to = NULL, ...)

\method{grab_index}{list}(x, from = NULL, to = NULL, ...)

\method{grab_index}{data.frame}(x, from = NULL, to = NULL, ...)

\method{grab_index}{matrix}(x, from = NULL, to = NULL, ...)
}
\arguments{
\item{x}{A character vector, \code{\link[base]{data.frame}}, or list.}

\item{from}{An integer to start from (if \code{NULL} defaults to the first
element/row).}

\item{to}{A integer to get up to (if \code{NULL} defaults to the last
element/row).}

\item{\ldots}{ignored.}
}
\value{
Returns a subset of the original data set.
}
\description{
Use regexes to get all the elements between two points.
}
\examples{
grab_index(DATA, from = 2, to = 4)
grab_index(DATA$state, from = 2, to = 4)
grab_index(DATA$state, from = 2)
grab_index(DATA$state, to = 4)
grab_index(matrix(1:100, nrow = 10), 2, 4)
}
