% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minhash.R
\name{minhash_generator}
\alias{minhash_generator}
\title{Generate a minhash function}
\usage{
minhash_generator(n = 200, seed = NULL)
}
\arguments{
\item{n}{The number of minhashes that the returned function should generate.}

\item{seed}{An option parameter to set the seed used in generating the random
numbers to ensure that the same minhash function is used on repeated
applications.}
}
\value{
A function which will take a character vector and return \code{n}
  minhashes.
}
\description{
A minhash value is calculated by hashing the strings in a character vector to
integers and then selecting the minimum value. Repeated minhash values are
generated by using different hash functions: these different hash functions
are created by using performing a bitwise \code{XOR} operation
(\code{\link{bitwXor}}) with a vector of random integers. Since it is vital
that the same random integers be used for each document, this function
generates another function which will always use the same integers. The
returned function is intended to be passed to the \code{hash_func} parameter
of \code{\link{TextReuseTextDocument}}.
}
\examples{
set.seed(253)
minhash <- minhash_generator(10)

# Example with a TextReuseTextDocument
file <- system.file("extdata/legal/ny1850-match.txt", package = "textreuse")
doc <- TextReuseTextDocument(file = file, hash_func = minhash,
                             keep_tokens = TRUE)
hashes(doc)

# Example with a character vector
is.character(tokens(doc))
minhash(tokens(doc))
}
\references{
Jure Leskovec, Anand Rajaraman, and Jeff Ullman,
  \href{http://www.mmds.org/#book}{\emph{Mining of Massive Datasets}}
  (Cambridge University Press, 2011), ch. 3. See also Matthew Casperson,
  "\href{http://matthewcasperson.blogspot.com/2013/11/minhash-for-dummies.html}{Minhash
   for Dummies}" (November 14, 2013).
}
\seealso{
\code{\link{lsh}}
}
