% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsh_query.R
\name{lsh_query}
\alias{lsh_query}
\title{Query a LSH cache for matches to a single document}
\usage{
lsh_query(buckets, id)
}
\arguments{
\item{buckets}{An \code{lsh_buckets} object created by \code{\link{lsh}}.}

\item{id}{The document ID to find matches for.}
}
\value{
An \code{lsh_candidates} data frame with matches to the document specified.
}
\description{
This function retrieves the matches for a single document from an \code{lsh_buckets} object created by \code{\link{lsh}}. See \code{\link{lsh_candidates}} to retrieve all pairs of matches.
}
\examples{
dir <- system.file("extdata/legal", package = "textreuse")
minhash <- minhash_generator(200, seed = 235)
corpus <- TextReuseCorpus(dir = dir,
                          tokenizer = tokenize_ngrams, n = 5,
                          minhash_func = minhash)
buckets <- lsh(corpus, bands = 50)
lsh_query(buckets, "ny1850-match")

}
\seealso{
\code{\link{lsh}}, \code{\link{lsh_candidates}}
}
