% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_gui.R
\name{generate_code_co_occurrence_analysis}
\alias{generate_code_co_occurrence_analysis}
\title{Generate code co-occurrence statistics and visualization}
\usage{
generate_code_co_occurrence_analysis(
  annotations,
  text = NULL,
  unit = "paragraph"
)
}
\arguments{
\item{annotations}{Data frame containing text annotations with columns:
\itemize{
\item start: numeric, starting position of annotation
\item end: numeric, ending position of annotation
\item code: character, code applied to the annotation
}}

\item{text}{Character string containing the original text (optional)}

\item{unit}{Character string specifying the analytical unit: "sentence", "paragraph", or "document"}
}
\value{
List containing:
\itemize{
\item co_occurrence: Matrix of raw co-occurrence counts
\item jaccard_similarity: Matrix of Jaccard similarity coefficients
\item phi_coefficient: Matrix of Phi coefficients
\item network_plot: Network visualization of code relationships
\item heatmap_plot: Heatmap visualization of code co-occurrences
\item summary: List of summary statistics
}
}
\description{
Performs a comprehensive analysis of code co-occurrences in the text, including
calculation of various similarity metrics and generation of network and heatmap
visualizations.
}
\keyword{internal}
