% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.term}
\alias{subset.term}
\title{Subset Term Vector}
\usage{
\method{subset}{term}(x, pars = NULL, select = NULL, ...)
}
\arguments{
\item{x}{The object.}

\item{pars}{A character vector of parameter names.}

\item{select}{A character vector of the names of the parameters to include in the subsetted object.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
The modified term vector.
}
\description{
Subsets a term vector.
}
\details{
The \code{select} argument is  \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}}.
}
\examples{
term <- term(
  "alpha[1]", "alpha[2]", "beta[1,1]", "beta[2,1]",
  "beta[1,2]", "beta[2,2]", "sigma"
)
subset(term, "beta")
subset(term, c("alpha", "sigma"))
}
\seealso{
\code{\link[=term-vector]{term-vector()}}
}
