% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_by_date.R
\name{ex_by_date}
\alias{ex_by_date}
\title{Extract environmental data by date}
\usage{
ex_by_date(this_species, train_prop = 0.7)
}
\arguments{
\item{this_species}{Species Temporal Data object. See
\code{\link[tenm]{sp_temporal_data}} for details.}

\item{train_prop}{Numeric. Proportion of data to use for training.
For example, a train_prop of 0.7 means 70\% of the data will be used for
training and 30\% for testing.}
}
\value{
An object of class sp.temporal.env that consists in a list of five
elements:
\enumerate{
\item "temporal_df": a temporal data.frame (temporal_df) with the following
columns: latitude, longitude, year, layer_dates, layers_path,
cell_ids_year, and environmental data.
\item "sp_date_var": Name of date variable.
\item "lon_lat_vars": Names of the longitude and latitude variables.
\item "layers_ext": Environmental layers extension.
\item "env_data": Environmental data of occurrences.
}
}
\description{
Function to extract environmental data by date. It generates training and
testing datasets using a random partition with a specified proportion.
}
\examples{
\donttest{
library(tenm)
data("abronia")
tempora_layers_dir <- system.file("extdata/bio",package = "tenm")
abt <- tenm::sp_temporal_data(occs = abronia,
                              longitude = "decimalLongitude",
                              latitude = "decimalLatitude",
                              sp_date_var = "year",
                              occ_date_format="y",
                              layers_date_format= "y",
                              layers_by_date_dir = tempora_layers_dir,
                              layers_ext="*.tif$")
abtc <- tenm::clean_dup_by_date(abt,threshold = 10/60)
future::plan("multisession",workers=2)
abex <- tenm::ex_by_date(this_species = abtc,
                         train_prop=0.7)
future::plan("sequential")
}
}
