% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsoid_omr.R
\name{ellipsoid_omr}
\alias{ellipsoid_omr}
\title{Compute omission rate and statistical metrics for ellipsoid models.}
\usage{
ellipsoid_omr(
  env_data,
  env_test = NULL,
  env_bg,
  cf_level,
  mve = TRUE,
  proc = FALSE,
  proc_iter = 100,
  rseed = TRUE
)
}
\arguments{
\item{env_data}{A data frame containing the environmental data used for
modeling.}

\item{env_test}{A data frame with environmental testing data.
Default is NULL. If provided, the selection process includes p-values
from a binomial test.}

\item{env_bg}{Environmental data sampled from the calibration area to compute
the approximated prevalence of the model.}

\item{cf_level}{Proportion of points to be included in the ellipsoids.
Equivalent to the error (E) proposed by Peterson et al. (2008).
\doi{10.1016/j.ecolmodel.2007.11.008}.}

\item{mve}{Logical. If \code{TRUE}, computes a minimum volume ellipsoid using
\code{\link[MASS]{cov.rob}} from the MASS package. If \code{FALSE},
uses the covariance matrix of the input data.}

\item{proc}{Logical. If \code{TRUE}, performs a partial ROC test.}

\item{proc_iter}{Numeric. Total number of iterations for the partial ROC
bootstrap.}

\item{rseed}{Logical. If \code{TRUE}, sets a random seed for the partial
ROC bootstrap. Default is \code{TRUE}.}
}
\value{
A data.frame with the following columns:
\itemize{
\item "fitted_vars": Names of variables that were fitted.
\item "nvars": Number of fitted variables
\item "om_rate_train": Omission rate of the training data.
\item "non_pred_train_ids": Row IDs of non-predicted training data.
\item "om_rate_test"': Omission rate of the testing data.
\item "non_pred_test_ids": Row IDs of non-predicted testing data.
\item "bg_prevalence": Approximated prevalence of the model (see details).
\item "pval_bin": p-value of the binomial test.
\item "pval_proc": p-value of the partial ROC test.
\item "env_bg_paucratio": Environmental partial AUC ratio value.
\item "env_bg_auc": Environmental AUC value.
}
}
\description{
Computes omission rate and statistical metrics for ellipsoid models using
environmental data.
}
\examples{
\donttest{
library(tenm)
data("abronia")
tempora_layers_dir <- system.file("extdata/bio",package = "tenm")
abt <- tenm::sp_temporal_data(occs = abronia,
                              longitude = "decimalLongitude",
                              latitude = "decimalLatitude",
                              sp_date_var = "year",
                              occ_date_format="y",
                              layers_date_format= "y",
                              layers_by_date_dir = tempora_layers_dir,
                              layers_ext="*.tif$")
abtc <- tenm::clean_dup_by_date(abt,threshold = 10/60)
#This code is for running in parallel
future::plan("multisession",workers=2)
abex <- tenm::ex_by_date(this_species = abtc,train_prop=0.7)
abbg <- tenm::bg_by_date(this_species = abex,
                         buffer_ngbs=10,n_bg=50000)
future::plan("sequential")
edata <- abex$env_data
etrain <- edata[edata$trian_test=="Train",c("bio_05","bio_06","bio_12")]
etest <- edata[edata$trian_test=="Test",c("bio_05","bio_06","bio_12")]
bg <- abbg$env_bg[,c("bio_05","bio_06","bio_12")]
eor <- ellipsoid_omr(env_data=etrain,env_test=etest,env_bg=bg,
                     cf_level=0.975,proc=TRUE)
eor
}
}
