% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_1.R
\name{vt1_super}
\alias{vt1_super}
\title{Estimate the CATE Using Super Learner for Step 1 of Virtual Twins}
\usage{
vt1_super(data, Trt, Y, SL.library, ...)
}
\arguments{
\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{SL.library}{Either a character vector of prediction algorithms or a
list containing character vector. See \code{SuperLearner} for more details.}

\item{...}{additional arguments to \code{SuperLearner}}
}
\value{
Estimated CATEs for each subject in \code{data}.
}
\description{
Estimate the CATE Using Super Learner for Step 1 of Virtual Twins
}
\seealso{
Other VT Step 1 functions: 
\code{\link{vt1_lasso}()},
\code{\link{vt1_mars}()},
\code{\link{vt1_rf}()}
}
\concept{VT Step 1 functions}
