% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{sample_dispersion}
\alias{sample_dispersion}
\alias{sample_circular_variance}
\alias{sample_circular_distance}
\alias{sample_circular_dispersion}
\title{Sample circular dispersion}
\usage{
sample_circular_variance(x, w = NULL, axial = TRUE)

sample_circular_distance(x, y, axial = TRUE, na.rm = TRUE)

sample_circular_dispersion(
  x,
  y = NULL,
  w = NULL,
  w.y = NULL,
  axial = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{x, y}{vectors of numeric values in degrees. \code{length(y)} is either
\code{1} or \code{length(x)}}

\item{w, w.y}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}. \code{w.y} is the (optional) weight of \code{y}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical. Whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\description{
Alternative versions of variance, dispersion a distance
(Mardia and Jupp, 1999; pp. 19-20).
These alternative dispersion has a minimum at the sample median.
}
\examples{
a <- c(0, 2, 359, 6, 354)
sample_circular_distance(a, 10) # distance to single value

b <- a + 90
sample_circular_distance(a, b) # distance to multiple values

data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
sample_circular_variance(sa.por$azi.PoR)
sample_circular_dispersion(sa.por$azi.PoR, y = 135)
sample_circular_dispersion(sa.por$azi.PoR, y = 135, w = weighting(san_andreas$unc))
}
\references{
N.I. Fisher (1993) Statistical Analysis of Circular Data, Cambridge
University Press.

Mardia, K.V., and Jupp, P.E (1999). Directional Statistics,
Wiley Series in Probability and Statistics. John Wiley & Sons, Inc.,
Hoboken, NJ, USA. \doi{10.1002/9780470316979}
}
