% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{ortensor2d}
\alias{ortensor2d}
\title{Orientation Tensor}
\usage{
ortensor2d(x, w = NULL, norm = FALSE)
}
\arguments{
\item{x}{numeric. Axial angular data (in degrees).}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{norm}{logical. Whether the tensor should be normalized.}
}
\value{
2x2 matrix
}
\description{
2D orientation tensor characterizes distribution of axial angles using the
Eigenvalue method (Watson 1966, Scheidegger 1965).
}
\details{
The moment of inertia can be minimized by calculating the Cartesian
coordinates of the orientation data, and calculating their covariance matrix.
This yields \deqn{I = x \cdot x^\intercal} where \eqn{x} is the Cartesian vector of the
orientations. Orientation tensor \eqn{T} and the inertia tensor \eqn{I} are
related by \deqn{I = E - T} where \eqn{E} denotes the unit matrix, so that
\deqn{T = \frac{1}{n} \sum_{i=i}^{n} x_i \cdot x_i^\intercal}
}
\examples{
test <- rvm(100, mean = 0, k = 10)
ortensor2d(test)
}
\references{
Watson, G. S. (1966). The Statistics of Orientation Data. The Journal of
Geology, 74(5), 786–797.

Scheidegger, A. E. (1964). The tectonic stress and tectonic motion direction
in Europe and Western Asia as calculated from earthquake fault plane
solutions. Bulletin of the Seismological Society of America, 54(5A),
1519–1528. doi:10.1785/BSSA05405A1519

Bachmann, F., Hielscher, R., Jupp, P. E., Pantleon, W., Schaeben, H., &
Wegert, E. (2010). Inferential statistics of electron backscatter diffraction
data from within individual crystalline grains. Journal of Applied
Crystallography, 43(6), 1338–1355. https://doi.org/10.1107/S002188981003027X
}
\seealso{
\code{\link[=ot_eigen2d]{ot_eigen2d()}}
}
