% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-constructor.R
\name{qenv}
\alias{qenv}
\title{Instantiates a \code{qenv} environment}
\usage{
qenv()
}
\value{
\code{qenv} environment.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Instantiates a \code{qenv} environment.
}
\details{
\code{qenv} class has following characteristics:
\itemize{
\item It inherits from the environment and methods such as \code{\link{$}}, \code{\link[=get]{get()}}, \code{\link[=ls]{ls()}}, \code{\link[=as.list]{as.list()}},
\code{\link[=parent.env]{parent.env()}} work out of the box.
\item \code{qenv} is a locked environment, and data modification is only possible through the \code{\link[=eval_code]{eval_code()}}
and \code{\link[=within.qenv]{within.qenv()}} functions.
\item It stores metadata about the code used to create the data (see \code{\link[=get_code]{get_code()}}).
\item It supports slicing (see \code{\link{subset-qenv}})
\item It is immutable which means that each code evaluation does not modify the original \code{qenv}
environment directly. See the following code:

\if{html}{\out{<div class="sourceCode">}}\preformatted{q1 <- qenv()
q2 <- eval_code(q1, "a <- 1")
identical(q1, q2) # FALSE
}\if{html}{\out{</div>}}
}
}
\examples{
q <- qenv()
q2 <- within(q, a <- 1)
ls(q2)
q2$a
}
\seealso{
\code{\link[=eval_code]{eval_code()}}, \code{\link[=get_var]{get_var()}}, \code{\link{subset-qenv}}, \code{\link[=get_env]{get_env()}},\code{\link[=get_warnings]{get_warnings()}}, \code{\link[=join]{join()}}, \code{\link[=concat]{concat()}}
}
