% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplObj.R
\name{tcplObj}
\alias{tcplObj}
\title{Concentration Response Objective Function}
\usage{
tcplObj(p, conc, resp, fname, errfun = "dt4", err = NULL)
}
\arguments{
\item{p}{Vector of parameters, must be in order: a, tp, b, ga, p, la, q, er.
Does not require names.}

\item{conc}{Vector of concentrations in log10 units for loghill/loggnls, in
regular units otherwise.}

\item{resp}{Vector of corresponding responses.}

\item{fname}{Name of model function.}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}

\item{err}{An optional estimation of error for the given fit.}
}
\value{
Log-likelihood.
}
\description{
Log-likelihood to be maximized during CR fitting.
}
\details{
This function is a generalized version of the log-likelihood estimation
functions used in the ToxCast Pipeline (TCPL).
Hill model uses fname "loghill" and gnls uses fname "loggnls". Other model
functions have the same fname as their model name; i.e. exp2 uses "exp2", etc.
errfun = "dnorm" may be better suited to gsva pathway scores than "dt4".
Setting err could be used to fix error based on the null data noise
distribution instead of fitting the error when maximizing log-likelihood.
}
\examples{
conc = c(.03,.1 , .3 , 1  , 3 , 10 , 30  , 100)
resp = c( 0 , 0 , .1 ,.2 , .5 , 1  , 1.5 , 2  )
p = c(tp = 2, ga = 3, p = 4, er = .5)
tcplObj(p,conc,resp,"exp5")

lconc = log10(conc)
tcplObj(p,lconc,resp,"loghill")
}
