% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_x.R
\name{replace_x}
\alias{replace_x}
\alias{replace_idx}
\alias{replace_na}
\title{Data manipulation.}
\usage{
replace_x(x, old, new)

replace_idx(x, idx1 = x, idx2 = idx1, new)

replace_na(x, idx1, idx2 = idx1, new)
}
\arguments{
\item{x}{A vector to be modified. In the case of \code{insert_rows()}, \code{x} is a
data frame.}

\item{old}{A vector with values to be replaced by \code{replace_x()} in a vector.}

\item{new}{A vector containing values to be inserted, either comparing values
or using indices.}

\item{idx1, idx2}{Indices applied for value replacements to match \code{x} with
\code{new}, respectively. If \code{idx2} is not provided, it will be assumed as
equivalent to \code{idx1}.}
}
\value{
A vector or data frame with the modified values.
}
\description{
This is a series of functions designed for a fast coding of replacements
both, as internal functions and in workflows dealing with information stored
in vectors.
Such functions are especially useful when handling with functional traits
stored in \linkS4class{taxlist} objects.

\code{replace_x()} is used to exchange values in vectors.
\code{replace_idx()} changes values in vectors by matching indices or conditions.
The function \code{replace_na()} works in the same way as \code{replace_idx()} but will
only insert values in empty elements (NAs).
}
\examples{
## Replace values in vector
replace_x(x = letters, old = c("b", "p", "f"), new = c("bee", "pork", "fungus"))

## Replace values using indices
replace_idx(x = letters, idx1 = 1:length(letters), idx2 = c(2, 7, 17),
  new = c("second", "seventh", "seventeenth"))

## Replace values if they are NAs
letters[2] <- NA
replace_na(x = letters, idx1 = 1:length(letters), idx2 = c(1:3),
  new = c("alpha", "beta", "zeta"))

## The same applications but this time for functional traits
summary(as.factor(Easplist$life_form))

# Merge annuals
Easplist@taxonTraits$lifeform <- replace_x(x = Easplist@taxonTraits$life_form,
  old = c("obligate_annual", "facultative_annual"), new = c("annual", "annual"))
summary(as.factor(Easplist$lifeform))

# The same effect
Easplist@taxonTraits$lifeform <- replace_idx(x = Easplist@taxonTraits$life_form,
  idx1 = grepl("annual", Easplist@taxonTraits$life_form), idx2 = TRUE,
  new = "annual")
summary(as.factor(Easplist$lifeform))
}
\author{
Miguel Alvarez.
}
