% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_sl.R
\name{cv.learner_sl}
\alias{cv.learner_sl}
\title{Cross-validation for \link{learner_sl}}
\usage{
\method{cv}{learner_sl}(object, data, nfolds = 5, rep = 1, model.score = scoring, ...)
}
\arguments{
\item{object}{(learner_sl) Instantiated \link{learner_sl} object.}

\item{data}{data.frame or matrix}

\item{nfolds}{Number of folds (nfolds=0 simple test/train split into two
folds 1:([n]/2), ([n]+1/2):n with last part used for testing)}

\item{rep}{Number of repetitions (default 1)}

\item{model.score}{Model scoring metric (default: MSE / Brier score). Must be
a function with arguments response and prediction, and may optionally
include weights, object and newdata arguments}

\item{...}{Additional arguments parsed to elements in \code{object}}
}
\description{
Cross-validation estimation of the generalization error of the
super learner and each of the separate models in the ensemble. Both the
chosen model scoring metrics as well as the model weights of the stacked
ensemble.
}
\examples{
sim1 <- function(n = 5e2) {
   x1 <- rnorm(n, sd = 2)
   x2 <- rnorm(n)
   y <- x1 + cos(x1) + rnorm(n, sd = 0.5**.5)
   data.frame(y, x1, x2)
}
sl <- learner_sl(list(
                   "mean" = learner_glm(y ~ 1),
                   "glm" = learner_glm(y ~ x1),
                   "glm2" = learner_glm(y ~ x1 + x2)
                  ))
cv(sl, data = sim1(), rep = 2)
}
