# This test suite checks that the plots generated by this package make sense.
# It uses testthat::expect_snapshot_file. This is how it works:
#
# The first time expect_snapshot_file is run, it creates a reference image. An
# expert validates it manually, and it gets stored.
#
# Every other time expect_snapshot_file is run, it compares the output with the
# reference image. If the new and the reference image are identical, the test
# passes. Otherwise, it fails.
#
# When fail, testthat provides some useful tools to visualy compare the differences
# between new and reference image. They are clickable from the test menu.

# Load the test data
testdata <- get_ifadv()

#' Auxiliary decorator
#'
#' This decorator extends the functionality of any plotting function with:
#'
#' 1. Saving the plot to a png file
#' 2. Returning the path
#'
#' This is required by testthat::expect_snapshot_file to work with graphics.
#' More information at:
#'
#' https://indrajeetpatil.github.io/intro-to-snapshot-testing/#/writing-test
#'
#' @param plot_function The plotting function to be tested
#' @param path The output filename
#' @param width (optional)
#' @param height (optional)
#'
#' @return The output filename
#'
with_save <- function(plot_function, path, width=800, height=350) {

  decorated <- function(...) {

    png(path, width, height) # Create a file placeholder for the plot,
    p <- plot_function(...) # generate the plot...
    dev.off() # ... export it as png and close connection

    return(path)
  }

  return(decorated)
}

#' Skip if not linux
#'
#' Plot saving is OS dependent. For the sake of sanity, we'll test the plot
#' snapshots only in Linux
#'
#' @return Nothing
#'
skip_if_not_linux <- function() {
  if(Sys.info()["sysname"] == "Linux") {
    # Do nothing
  } else {
    skip("This test is designed to run on Linux machines only")
  }
}

test_that("Plot quality", {
  skip_if_not_linux()

  path <- "plot_quality.png"
  plot_quality_with_save <- with_save(plot_quality, path)

  expect_snapshot_file(
    plot_quality_with_save(testdata),
    path
  )

  on.exit(file.remove(path)) # Clean afterwards
})

