% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabcount.R
\name{tabcount}
\alias{tabcount}
\title{Count distinct categories}
\usage{
tabcount(df, ...)
}
\arguments{
\item{df}{A data.table, tibble, or data.frame}

\item{...}{A column or set of columns (without quotation marks)}
}
\value{
Count of the number of unique groups formed by the variables given in \code{...} from \code{df}.
}
\description{
Produces a count of unique categories,
\code{tabcount} shows the number of
	unique categories for the selected variable.
		Accepts data.table, tibble, or data.frame as input.
Efficient with big data: if you give it a \code{data.table},
		\code{tabcount} uses \code{data.table} syntax.
}
\examples{
# data.table
library(data.table)
library(magrittr)
a <- data.table(varname = sample.int(20, size = 1000000, replace = TRUE))
a \%>\% tabcount(varname)

# tibble
library(dplyr)
b <- tibble(varname = sample.int(20, size = 1000000, replace = TRUE))
b \%>\% tabcount(varname)

}
