% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{internode_distances}
\alias{internode_distances}
\title{Get internode distances between primary branches from a QSM}
\usage{
internode_distances(qsm, min_diam = 2)
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{min_diam}{numeric - minimum diameter (in cm) to include branch}
}
\value{
A numeric vector of internode distances (m) between consecutive
primary branches that meet the diameter threshold. Returns `NA` if fewer
than two qualifying primary branches are present.
}
\description{
This function estimates the internode distance between primary branches
from a QSM. It filters out all primary branches `branching_order == 1`
calculates their attachment points (Z) to the trunk, and then
returns the distances betweent the branches
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
inodes = internode_distances(qsm)
print(inodes)
median(inodes)
}
