% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_sync.R
\name{full_asym_sync_to_right}
\alias{full_asym_sync_to_right}
\title{Full asymmetric synchronization to right directory}
\usage{
full_asym_sync_to_right(
  left_path = NULL,
  right_path = NULL,
  sync_status = NULL,
  by_date = TRUE,
  by_content = FALSE,
  recurse = TRUE,
  force = TRUE,
  delete_in_right = TRUE,
  backup = FALSE,
  backup_dir = "temp_dir",
  verbose = getOption("syncdr.verbose")
)
}
\arguments{
\item{left_path}{Path to the left/first directory.}

\item{right_path}{Path to the right/second directory.}

\item{sync_status}{Object of class "syncdr_status", output of \code{compare_directories()}.}

\item{by_date}{Logical. If TRUE, synchronize based on file modification dates (default is TRUE).}

\item{by_content}{Logical. If TRUE, synchronize based on file contents (default is FALSE).}

\item{recurse}{Logical. If TRUE (default), files are copied to corresponding subdirectories
in the destination folder. If FALSE, files are copied to the top level of the destination folder
without creating subdirectories if they do not exist.}

\item{force}{Logical. If TRUE (by default), directly perform synchronization of the directories.
If FALSE, Displays a preview of actions and prompts the user for confirmation before proceeding. Synchronization is aborted if the user does not agree.}

\item{delete_in_right}{Logical. If TRUE (default), files that exist only in the
right directory (i.e., absent from the left directory) are deleted during
synchronization. If FALSE, no files are removed from the right directory,
even if they are exclusive to it.}

\item{backup}{Logical. If TRUE, creates a backup of the right directory before synchronization. The backup is stored in the location specified by \code{backup_dir}.}

\item{backup_dir}{Path to the directory where the backup of the original right directory will be stored. If not specified, the backup is stored in temporary directory (\code{tempdir}).}

\item{verbose}{logical. If TRUE, display directory tree before and after synchronization. Default is FALSE}
}
\value{
Invisible TRUE indicating successful synchronization.
}
\description{
This function performs a full asymmetric synchronization of the right directory
based on the left directory. It includes the following synchronization steps (see Details below):
}
\details{
\itemize{
\item For common files:
\itemize{
\item If comparing by date only (\code{by_date = TRUE}): Copy files that are newer in the left directory to the right directory.
\item If comparing by date and content (\code{by_date = TRUE} and \code{by_content = TRUE}): Copy files that are newer and different in the left directory to the right directory.
\item If comparing by content only (\code{by_content = TRUE}): Copy files that are different in the left directory to the right directory.
}
\item Copy to the right directory those files that exist only in the left directory.
\item Delete from the right directory those files that are exclusive in the right directory (i.e., missing in the left directory)
}
}
\examples{
\donttest{
e <- toy_dirs(fast = TRUE)
left  <- e$left
right <- e$right
full_asym_sync_to_right(
  left_path  = left,
  right_path = right,
  by_date    = FALSE,
  by_content = TRUE
)
sync_status <- compare_directories(left_path = left, right_path = right)
full_asym_sync_to_right(sync_status = sync_status)
}
}
